<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Impressão da Conta</title>
    <style>
        @color-gray: #BCBCBC;

        .text {
            text-align: center;
        }

        .ttu { text-transform: uppercase; }

        * {
            font-family: Tahoma, Geneva, sans-serif; 
            font-size: 10px; 
        }

        .printer-ticket {
            display: table !important;
            width: 100%;
            max-width: 400px;
            font-weight: light;
            line-height: 1.3em;
        }

        th:nth-child(2),
        td:nth-child(2) {
            width: 50px;
        }
        
        th:nth-child(3) ,
        td:nth-child(3) { 
            width: 90px; text-align: right; 
        }
        
        th { 
            font-weight: inherit;
            padding: 1em;
            text-align: center;
            border-bottom: 1px dashed #000;
        }


        tr:last-child td { padding-bottom: 0; }

        .sup td {
            padding: 1em 0;
            border-top: 1px dashed #000;
        }
        
        .sup.p--0 td { padding-bottom: 0; }            
        
        .title { 
            font-size: 2em; 
            padding: 1.5 0; 
        }

        .top td { padding-top: 0; }
        
        .last td { padding-bottom: 0; }

        @media print
        {    
            .no-print, .no-print *
            {
                display: none !important;
            }
        }
        
        .back { font-size: 18px; }
    </style>
</head>
<body>

<a href="{{url('pedido/cardapios')}}" class="no-print back">
    Voltar
</a>


    <table class="printer-ticket" width="100%">
        <thead>
            <tr>
                <th colspan="4">
                    <b class="title">{{ config("parque.nome") }}</b>
                </th>
            </tr>
            <!-- <tr>
                <th colspan="4">
                    CLIENTE: {{ mb_strtoupper($params->cartaoCliente->nome) }} <br>
                    {{ date("d/m/Y") }} - {{ date("H:i:s") }}
                </th>
            </tr> -->
        </thead>
        <tbody>

            @foreach($params->pedidoClienteImpressao as $pdv => $pedidos)
                <tr>
                    <th colspan="4" width="5%"><b>{{ $pdv  }}</b></th>
                </tr>
                <tr>
                    <th colspan="4">
                        CLIENTE: {{ mb_strtoupper($params->cartaoCliente->nome) }} <br>
                        {{ date("d/m/Y") }} - {{ date("H:i:s") }}
                    </th>
                </tr>

                <tr>
                    <th width="70%"><b>Pedido</b></th>
                    <th width="5%"><b>Mesa</b></th>
                    <th style="text-align: right;" width="5%"><b>Qtd.</b></th>
                    <th width="20%"><b>Valor</b></th>
                </tr>
                @foreach($pedidos as $item)
                    <tr>
                        <td>{{ mb_strtoupper($item->categoria) }}: {{ mb_strtoupper($item->nome_produto) }}</td>
                        <td align="center">{{ $item->mesa }}</td>
                        <td align="center">{{ ($item->quantidade >= 1 ? intval($item->quantidade) : $item->quantidade)  }}</td>
                        <td align="right">R${{ number_format($item->valor, 2, ',', '.') }}</td>
                    </tr>
                @endforeach

                <tr>
                    <td colspan="4">&nbsp;</td>
                </tr>

                <tr>
                    <th colspan="4">
                        &nbsp;
                    </th>
                </tr>
            @endforeach
        </tbody>
        <tfoot>
            <tr class="">
                <td colspan="4" align="center">
                    www.paynow.tec.br
                </td>
            </tr>
        </tfoot>
    </table>


<script>
    window.print();
</script>
</body>
</html>
